/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.via6522;

import frc.emul.api.ILogger;
import frc.emul.api.persistence.IPersistenceReader;
import frc.emul.api.persistence.IPersistenceWriter;
import frc.emul.api.persistence.IPersistentObject;
import frc.emul.api.persistence.IPersistentSection;
import frc.emul.api.persistence.PersistenceException;
import frc.emul.util.Utils;
import frc.emul.vectrex.PersistentSection;
import frc.emul.via6522.I6522Core;
import frc.emul.via6522.I6522InternalLines;
import frc.emul.via6522.I6522InternalListener;
import frc.emul.via6522.I6522TimerListener;
import java.util.ArrayList;
import java.util.List;

public class Via6522
implements I6522InternalListener,
I6522Core,
IPersistentObject {
    private static final boolean DO_TRACE = false;
    public static final int AC_LATCH_A = 1;
    public static final int AC_LATCH_B = 2;
    public static final int AC_SR0 = 4;
    public static final int AC_SR1 = 8;
    public static final int AC_SR2 = 16;
    public static final int AC_T2_PB6 = 32;
    public static final int AC_T1_FREE = 64;
    public static final int AC_PB7_OUT = 128;
    public static final int AC_SR = 28;
    public static final int PC_CA1 = 1;
    public static final int PC_CA2_B0 = 2;
    public static final int PC_CA2_B1 = 4;
    public static final int PC_CA2_B2 = 8;
    public static final int PC_CB1 = 16;
    public static final int PC_CB2_B0 = 32;
    public static final int PC_CB2_B1 = 64;
    public static final int PC_CB2_B2 = 128;
    public static final int PC_CB2 = 224;
    public static final int PC_CA2 = 14;
    public static final int IF_CA2 = 1;
    public static final int IF_CA1 = 2;
    public static final int IF_SHIFT = 4;
    public static final int IF_CB2 = 8;
    public static final int IF_CB1 = 16;
    public static final int IF_TIMER2 = 32;
    public static final int IF_TIMER1 = 64;
    public static final int IF_IRQ = 128;
    public static final int IE_CA2 = 1;
    public static final int IE_CA1 = 2;
    public static final int IE_SHIFT = 4;
    public static final int IE_CB2 = 8;
    public static final int IE_CB1 = 16;
    public static final int IE_TIMER2 = 32;
    public static final int IE_TIMER1 = 64;
    public static final int IE_SETCLR = 128;
    public static final int SR_MODE_MASK = 16;
    public static final int SR_MODE_INPUT = 0;
    public static final int SR_MODE_OUTPUT = 16;
    public static final int SR_OFF = 0;
    public static final int SR_IN_T2 = 4;
    public static final int SR_IN_CLOCK = 8;
    public static final int SR_IN_CB1 = 12;
    public static final int SR_OUT_T2_FREE = 16;
    public static final int SR_OUT_T2 = 20;
    public static final int SR_OUT_CLOCK = 24;
    public static final int SR_OUT_CB1 = 28;
    public static final int CA2_MODE_MASK = 8;
    public static final int CA2_MODE_INPUT = 0;
    public static final int CA2_MODE_OUTPUT = 8;
    public static final int CA2_IN_LOW = 0;
    public static final int CA2_IN_LOW_INDEP = 2;
    public static final int CA2_IN_HI = 4;
    public static final int CA2_IN_HIGH_INDEP = 6;
    public static final int CA2_HANDSHAKE = 8;
    public static final int CA2_PULSE = 10;
    public static final int CA2_LOW = 12;
    public static final int CA2_HIGH = 14;
    public static final int CB2_MODE_MASK = 128;
    public static final int CB2_MODE_INPUT = 0;
    public static final int CB2_MODE_OUTPUT = 128;
    public static final int CB2_IN_LOW = 0;
    public static final int CB2_IN_LOW_INDEP = 32;
    public static final int CB2_IN_HI = 64;
    public static final int CB2_IN_HIGH_INDEP = 96;
    public static final int CB2_HANDSHAKE = 128;
    public static final int CB2_PULSE = 160;
    public static final int CB2_LOW = 192;
    public static final int CB2_HIGH = 224;
    private static final int SR_DELAY_T2L = 51966;
    private transient I6522InternalLines lines;
    private transient ILogger logger;
    private transient List<I6522TimerListener> timerListeners = new ArrayList<I6522TimerListener>();
    private int writtenReg1;
    private int writtenReg2;
    private int writtenVal1;
    private int writtenVal2;
    private int ORB;
    private int IRB;
    private int DDRB;
    private int ORA;
    private int IRA;
    private int DDRA;
    private int T1C;
    private int T1LL;
    private int T1LH;
    private int T2C;
    private int T2LL;
    private int SR;
    private int ACR;
    private int PCR;
    private int IFR;
    private int IER;
    private int SR_bits;
    private int SR_delay;
    private boolean SR_armed;
    private boolean T1_run;
    private boolean T1_pb7;
    private boolean T2_run;
    private boolean T2_armed;
    private int T2_pb6;

    public Via6522(ILogger iLogger, I6522InternalLines i6522InternalLines) {
        this.logger = iLogger;
        this.lines = i6522InternalLines;
        i6522InternalLines.add6522Listener(this);
    }

    public void initialise() {
        this.writtenReg1 = -1;
        this.writtenReg2 = -1;
        this.SR_bits = 8;
        this.SR_delay = 0;
    }

    public void reset() {
        this.DDRB = 0;
        this.IRB = 0;
        this.ORB = 0;
        this.DDRA = 0;
        this.IRA = 0;
        this.ORA = 0;
        this.PCR = 0;
        this.ACR = 0;
        this.IER = 0;
        this.clearIF(-129);
        this.T2_run = false;
        this.T1_run = false;
        this.initialise();
        this.outputPA();
        this.outputPB();
        this.setCB1(false);
        this.setCB2(false);
        this.setCA2(false);
    }

    public void addTimerListener(I6522TimerListener i6522TimerListener) {
        this.timerListeners.add(i6522TimerListener);
    }

    public void removeTimerListener(I6522TimerListener i6522TimerListener) {
        this.timerListeners.remove(i6522TimerListener);
    }

    public void step() {
        if (this.T1_run) {
            this.stepTimer1();
        }
        if (this.T2_run) {
            this.stepTimer2();
        }
        if ((this.ACR & 0x1C) != 0) {
            this.shiftOut();
        }
    }

    private void shiftOut() {
        if (this.SR_bits > 7) {
            return;
        }
        if (this.SR_delay >= 51966) {
            if ((this.T2C & 0xFF) != 0) {
                if (this.SR_delay > 51966) {
                    --this.SR_delay;
                } else {
                    this.setCB1(false);
                }
                return;
            }
            this.SR_delay = 51968;
        } else {
            if (--this.SR_delay > 0) {
                this.setCB1(false);
                return;
            }
            this.SR_delay = 2;
        }
        ++this.SR_bits;
        int n = this.SR >> 7 & 1;
        this.SR = (this.SR << 1 | n) & 0xFF;
        this.setCB2(n == 1);
        this.setCB1(true);
        if (this.SR_bits == 8 && this.SR_armed) {
            this.SR_armed = false;
            this.setIF(4);
        }
    }

    private void stepTimer1() {
        if (--this.T1C >= 0) {
            return;
        }
        if ((this.ACR & 0x40) != 0) {
            this.T1C = this.T1LH << 8 | this.T1LL;
        } else {
            this.T1_run = false;
        }
        this.setT1PB7(!this.T1_pb7);
        this.setIF(64);
        this.fireTimerTimeout(1);
    }

    private void stepTimer2() {
        if ((this.ACR & 0x20) != 0) {
            int n = this.lines.via_read_PB() & 0x40;
            if ((n ^ this.T2_pb6) == 0) {
                return;
            }
            this.T2_pb6 = n;
            if (n != 0) {
                return;
            }
            this.T2C = this.T2C - 1 & 0xFFFF;
            if (this.T2C > 0) {
                return;
            }
        } else {
            if (--this.T2C >= 0) {
                return;
            }
            this.T2C &= 0xFFFF;
        }
        if (this.T2_armed) {
            this.T2_armed = false;
            this.setIF(32);
            this.fireTimerTimeout(2);
        }
    }

    public synchronized void externalPortWritten(int n, int n2) {
        switch (n) {
            case 0: {
                if ((this.ACR & 1) != 0) break;
                this.IRA = n2;
                break;
            }
            case 1: {
                if ((this.ACR & 2) != 0) break;
                this.IRB = n2;
            }
        }
    }

    public synchronized void externalLineWritten(int n, boolean bl) {
        switch (n) {
            case 0: {
                if (!(bl ^ (this.PCR & 1) == 0)) break;
                if ((this.ACR & 1) != 0) {
                    this.IRA = this.lines.via_read_PA();
                }
                this.setIF(2);
                break;
            }
            case 2: {
                if (!(bl ^ (this.PCR & 0x10) == 0)) break;
                if ((this.ACR & 2) != 0) {
                    this.IRB = this.lines.via_read_PB();
                }
                this.setIF(16);
            }
        }
    }

    private int getViaPortA(boolean bl) {
        int n = (this.ACR & 1) != 0 ? this.IRA : this.lines.via_read_PA();
        this.clearIF_CAx();
        return n;
    }

    public int getViaPortB() {
        int n = this.ORB & this.DDRB;
        n = (this.ACR & 2) != 0 ? (n |= ~this.DDRB & this.IRB) : (n |= ~this.DDRB & this.lines.via_read_PB());
        if ((this.ACR & 0x80) != 0) {
            n = this.T1_pb7 ? (n |= 0x80) : (n &= 0x7F);
        }
        this.clearIF_CBx();
        return n;
    }

    public int getViaPortA() {
        return this.getViaPortA(true);
    }

    public int getViaDDRB() {
        return this.DDRB;
    }

    public int getViaDDRA() {
        return this.DDRA;
    }

    public int getViaT1CL() {
        this.clearIF(64);
        return this.T1C & 0xFF;
    }

    public int getViaT1CH() {
        return this.T1C >> 8 & 0xFF;
    }

    public int getViaT1LL() {
        return this.T1LL;
    }

    public int getViaT1LH() {
        return this.T1LH;
    }

    public int getViaT2CL() {
        this.clearIF(32);
        return this.T2C & 0xFF;
    }

    public int getViaT2CH() {
        return this.T2C >> 8 & 0xFF;
    }

    public int getViaSR() {
        this.SR_delay = 20 == (this.ACR & 0x1C) ? 51966 : 3;
        this.SR_bits = 0;
        this.SR_armed = true;
        this.clearIF(4);
        return this.SR;
    }

    public int getViaACR() {
        return this.ACR;
    }

    public int getViaPCR() {
        return this.PCR;
    }

    public int getViaIFR() {
        return this.IFR;
    }

    public int getViaIER() {
        return this.IER | 0x80;
    }

    public int getViaAnoHS() {
        return this.getViaPortA(false);
    }

    public void setVia(int n, int n2) {
        if (this.writtenReg1 < 0) {
            this.writtenReg1 = n;
            this.writtenVal1 = n2;
        } else {
            this.writtenReg2 = n;
            this.writtenVal2 = n2;
        }
    }

    public void stepped() {
        if (this.writtenReg1 >= 0) {
            this.consumeWriteEvent(this.writtenReg1, this.writtenVal1);
            this.writtenReg1 = -1;
            if (this.writtenReg2 >= 0) {
                this.consumeWriteEvent(this.writtenReg2, this.writtenVal2);
                this.writtenReg2 = -1;
            }
        }
    }

    private void consumeWriteEvent(int n, int n2) {
        switch (n) {
            case 0: {
                this.setViaPortB(n2);
                return;
            }
            case 1: {
                this.setViaPortA(n2);
                return;
            }
            case 2: {
                this.setViaDDRB(n2);
                return;
            }
            case 3: {
                this.setViaDDRA(n2);
                return;
            }
            case 4: {
                this.setViaT1CL(n2);
                return;
            }
            case 5: {
                this.setViaT1CH(n2);
                return;
            }
            case 6: {
                this.setViaT1LL(n2);
                return;
            }
            case 7: {
                this.setViaT1LH(n2);
                return;
            }
            case 8: {
                this.setViaT2CL(n2);
                return;
            }
            case 9: {
                this.setViaT2CH(n2);
                return;
            }
            case 10: {
                this.setViaSR(n2);
                return;
            }
            case 11: {
                this.setViaACR(n2);
                return;
            }
            case 12: {
                this.setViaPCR(n2);
                return;
            }
            case 13: {
                this.setViaIFR(n2);
                return;
            }
            case 14: {
                this.setViaIER(n2);
                return;
            }
            case 15: {
                this.setViaAnoHS(n2);
                return;
            }
        }
        throw new IllegalArgumentException("Write access to an invalid VIA register index (" + n + ")");
    }

    private void setViaPortA(int n, boolean bl) {
        this.ORA = n;
        this.clearIF_CAx();
        this.outputPA();
    }

    public void setViaPortB(int n) {
        this.ORB = n;
        this.outputPB();
        this.clearIF_CBx();
    }

    public void setViaPortA(int n) {
        this.setViaPortA(n, true);
    }

    public void setViaDDRB(int n) {
        this.DDRB = n;
        this.outputPB();
    }

    public void setViaDDRA(int n) {
        this.DDRA = n;
    }

    public void setViaT1CL(int n) {
        this.T1LL = n;
    }

    public void setViaT1CH(int n) {
        this.clearIF(64);
        this.T1LH = n;
        this.T1C = n << 8 | this.T1LL;
        this.T1_run = true;
        this.setT1PB7(false);
        this.fireTimerStarting(1, this.T1C);
    }

    public void setViaT1LL(int n) {
        this.T1LL = n;
    }

    public void setViaT1LH(int n) {
        this.T1LH = n;
        this.clearIF(64);
    }

    public void setViaT2CL(int n) {
        this.T2LL = n;
    }

    public void setViaT2CH(int n) {
        this.clearIF(32);
        this.T2C = n << 8 | this.T2LL;
        this.T2_run = true;
        this.T2_armed = true;
        this.T2_pb6 = this.lines.via_read_PB() & 0x40;
        this.fireTimerStarting(2, this.T2C);
    }

    public void setViaSR(int n) {
        this.SR = n;
        this.getViaSR();
    }

    public void setViaACR(int n) {
        int n2 = this.ACR ^ n;
        this.ACR = n;
        if ((n2 & 0x20) != 0) {
            this.T2_pb6 = this.lines.via_read_PB() & 0x40;
        }
        if ((n2 & 0x80) != 0) {
            this.outputPB();
        }
        switch (n & 0x1C) {
            case 0: {
                this.SR_bits = 8;
                break;
            }
            case 20: 
            case 24: {
                break;
            }
            case 28: {
                throw new RuntimeException("Unsupported SHIFT mode (ACR=" + Utils.bin(8, this.ACR) + ") -> Shift OUT, controlled by External Clock (on CB1)");
            }
            default: {
                throw new RuntimeException("Unsupported SHIFT mode (ACR=" + Utils.bin(8, this.ACR) + ")");
            }
        }
    }

    public void setViaPCR(int n) {
        this.PCR = n;
        switch (n & 0xE) {
            case 12: {
                this.setCA2(false);
                break;
            }
            case 14: {
                this.setCA2(true);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported CA2 mode (PCR=" + Utils.bin(8, this.PCR) + ")");
            }
        }
        switch (n & 0xE0) {
            case 192: {
                this.setCB2(false);
                break;
            }
            case 224: {
                this.setCB2(true);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported CB2 mode (PCR=" + Utils.bin(8, this.PCR) + ")");
            }
        }
    }

    public void setViaIFR(int n) {
        this.clearIF(n & 0xFFFFFF7F);
    }

    public void setViaIER(int n) {
        if ((n & 0x80) == 0) {
            if (n == 0) {
                n = 2;
            }
            this.IER &= ~(n & 0xFFFFFF7F);
        } else {
            this.IER |= n & 0xFFFFFF7F;
        }
        this.updateIRQ();
    }

    public void setViaAnoHS(int n) {
        this.setViaPortA(n, false);
    }

    private void setCA2(boolean bl) {
        this.lines.via_write_CA2(bl);
    }

    private void setCB1(boolean bl) {
        this.lines.via_write_CB1(bl);
    }

    private void setCB2(boolean bl) {
        this.lines.via_write_CB2(bl);
    }

    private void setT1PB7(boolean bl) {
        this.T1_pb7 = bl;
        if ((this.ACR & 0x80) != 0) {
            this.outputPB();
        }
    }

    private void outputPB() {
        int n = this.ORB & this.DDRB | this.lines.via_read_PB() & ~this.DDRB;
        if ((this.ACR & 0x80) != 0) {
            n = this.T1_pb7 ? (n |= 0x80) : (n &= 0x7F);
        }
        this.lines.via_write_PB(n, this.DDRB);
    }

    private void outputPA() {
        this.lines.via_write_PA(this.ORA, this.DDRA);
    }

    private void updateIRQ() {
        if ((this.IFR & 0x80) != 0) {
            this.clearIF(0);
        } else {
            this.setIF(0);
        }
    }

    private void setIF(int n) {
        this.IFR |= n;
        if ((this.IFR & this.IER) != 0 && (this.IFR & 0x80) == 0) {
            this.IFR |= 0x80;
            this.lines.via_write_IRQ(true);
        }
    }

    private void clearIF(int n) {
        this.IFR &= ~n;
        if ((this.IFR & this.IER) == 0 && (this.IFR & 0x80) != 0) {
            this.IFR &= 0xFFFFFF7F;
            this.lines.via_write_IRQ(false);
        }
    }

    private void clearIF_CAx() {
        this.clearIF((this.PCR & 0xA) == 0 ? 3 : 2);
    }

    private void clearIF_CBx() {
        this.clearIF((this.PCR & 0xA0) == 0 ? 24 : 16);
    }

    private final void fireTimerStarting(int n, int n2) {
        int n3 = this.timerListeners.size();
        while (n3-- > 0) {
            this.timerListeners.get(n3).timerStarting(n, n2);
        }
    }

    private final void fireTimerTimeout(int n) {
        int n2 = this.timerListeners.size();
        while (n2-- > 0) {
            this.timerListeners.get(n2).timerTimeout(n);
        }
    }

    private void trace(String string) {
    }

    public IPersistentSection getSection() {
        return PersistentSection.VIA;
    }

    public void store(IPersistenceWriter iPersistenceWriter) throws PersistenceException {
        iPersistenceWriter.write8(this.writtenReg1);
        iPersistenceWriter.write8(this.writtenReg2);
        iPersistenceWriter.write16(this.writtenVal1);
        iPersistenceWriter.write16(this.writtenVal2);
        iPersistenceWriter.write16(this.ORB);
        iPersistenceWriter.write16(this.IRB);
        iPersistenceWriter.write16(this.DDRB);
        iPersistenceWriter.write16(this.ORA);
        iPersistenceWriter.write16(this.IRA);
        iPersistenceWriter.write16(this.DDRA);
        iPersistenceWriter.write16(this.T1C);
        iPersistenceWriter.write16(this.T1LL);
        iPersistenceWriter.write16(this.T1LH);
        iPersistenceWriter.write16(this.T2C);
        iPersistenceWriter.write16(this.T2LL);
        iPersistenceWriter.write16(this.SR);
        iPersistenceWriter.write16(this.ACR);
        iPersistenceWriter.write16(this.PCR);
        iPersistenceWriter.write16(this.IFR);
        iPersistenceWriter.write16(this.IER);
        iPersistenceWriter.write8(this.SR_bits);
        iPersistenceWriter.write(this.SR_delay);
        iPersistenceWriter.write(this.SR_armed);
        iPersistenceWriter.write(this.T1_run);
        iPersistenceWriter.write(this.T1_pb7);
        iPersistenceWriter.write(this.T2_run);
        iPersistenceWriter.write(this.T2_armed);
        iPersistenceWriter.write(this.T2_pb6);
    }

    public void load(IPersistenceReader iPersistenceReader) throws PersistenceException {
        this.writtenReg1 = iPersistenceReader.readS8();
        this.writtenReg2 = iPersistenceReader.readS8();
        this.writtenVal1 = iPersistenceReader.readS16();
        this.writtenVal2 = iPersistenceReader.readS16();
        this.ORB = iPersistenceReader.readS16();
        this.IRB = iPersistenceReader.readS16();
        this.DDRB = iPersistenceReader.readS16();
        this.ORA = iPersistenceReader.readS16();
        this.IRA = iPersistenceReader.readS16();
        this.DDRA = iPersistenceReader.readS16();
        this.T1C = iPersistenceReader.readS16();
        this.T1LL = iPersistenceReader.readS16();
        this.T1LH = iPersistenceReader.readS16();
        this.T2C = iPersistenceReader.readS16();
        this.T2LL = iPersistenceReader.readS16();
        this.SR = iPersistenceReader.readS16();
        this.ACR = iPersistenceReader.readS16();
        this.PCR = iPersistenceReader.readS16();
        this.IFR = iPersistenceReader.readS16();
        this.IER = iPersistenceReader.readS16();
        this.SR_bits = iPersistenceReader.readS8();
        this.SR_delay = iPersistenceReader.readInt();
        this.SR_armed = iPersistenceReader.readBool();
        this.T1_run = iPersistenceReader.readBool();
        this.T1_pb7 = iPersistenceReader.readBool();
        this.T2_run = iPersistenceReader.readBool();
        this.T2_armed = iPersistenceReader.readBool();
        this.T2_pb6 = iPersistenceReader.readInt();
    }
}

